;-----------------------------------------------------------
; Error Codes
;-----------------------------------------------------------

EC_NOERROR		equ	0
EC_UNKNOWN		equ	1
EC_OUTOFMEMORY		equ	2
EC_INVALIDINDEX		equ	3
EC_FILEEXIST		equ	4
EC_VARINUSE		equ	5
EC_VARARCHIVED		equ	6
EC_NOTEMPTY		equ	7
EC_HDLNOTFOUND		equ	8
EC_ERRORMESSAGE		equ	9
EC_FOLDEREXIST		equ	10
EC_LINKERROR		equ	11
EC_PERSONAL		equ	12
EC_INVALIDFILE		equ	13

;-----------------------------------------------------------
; VAT constants
;-----------------------------------------------------------
VAT_FOLDERBIT		equ	7
VAT_SELECTBIT		equ	5
VAT_LOCKBIT		equ	3
VAT_HIDEBIT		equ	4
VAT_ARCHBIT		equ	1

VAT_ENTRYFLAG		equ	11
VAT_ENTRYHDL		equ	12
VAT_ENTRYSIZE		equ	14

VAT_ZIPPED		equ	1
VAT_NOTZIPPED		equ	0

;-----------------------------------------------------------
; File Extensions zero based Index
;-----------------------------------------------------------

NB_EXT		equ	19

EXT_ASM		 equ	 0	;ASM files except PlusShell/DoorsOS
EXT_DATA         equ     1	;DATA
EXT_EXE          equ     2	;PlusShell/DoorsOS ASM files
EXT_EXPR         equ     3	;EXPR
EXT_FIG          equ     4	;FIG
EXT_FUNC         equ     5	;FUNC
EXT_GDB          equ     6	;GDB
EXT_LIB          equ     7	;Fargo2 Library
EXT_LIST         equ     8	;LIST
EXT_MACR         equ     9	;MACR
EXT_MAT          equ     10	;MAT
EXT_PIC          equ     11	;PIC
EXT_PLUG         equ     12	;PLUG
EXT_PRGM         equ     13	;PRGM
EXT_STR          equ     14	;STR
EXT_TEXT         equ     15	;TEXT
EXT_ZIP		 equ	 16	;Compressed File
EXT_OTHER	 equ	 17	; $f8 terminated files
EXT_RUNC	 equ	 18	;RunC Files

;-------------------------------------------------------------
; Address of Interrupt vectors
;-------------------------------------------------------------
INT1_VECTOR	equ	$64
INT2_VECTOR	equ	$68
INT3_VECTOR	equ	$6C
INT4_VECTOR	equ	$70
INT5_VECTOR	equ	$74
INT6_VECTOR	equ	$78
INT7_VECTOR	equ	$7C
TRAP0_VECTOR	equ	$80
TRAP1_VECTOR	equ	$84
TRAP2_VECTOR	equ	$88
TRAP3_VECTOR	equ	$8C
TRAP4_VECTOR	equ	$90
TRAP5_VECTOR	equ	$94
TRAP6_VECTOR	equ	$98
TRAP7_VECTOR	equ	$9C
TRAP8_VECTOR	equ	$A0
TRAP9_VECTOR	equ	$A4
TRAP10_VECTOR	equ	$A8
TRAP11_VECTOR	equ	$AC
TRAP12_VECTOR	equ	$B0
TRAP13_VECTOR	equ	$B4
TRAP14_VECTOR	equ	$B8
TRAP15_VECTOR	equ	$BC



;---------------------------------------------------------------
; Interface Engine Constants
;---------------------------------------------------------------
IE_END		equ	0
IE_NOP		equ	1
IE_SETFONT	equ	2
IE_STRING	equ	3
IE_CHAR		equ	4
IE_SOLIDRECT	equ	5
IE_WIN		equ	6
IE_GFX8		equ	7
IE_GFX16	equ	8
IE_INVERTAREA	equ	9
IE_SAVEFONT	equ	10
IE_RESTOREFONT	equ	11
IE_STRINGADDR	equ	12
IE_WIN2		equ	13
IE_ANIMEDWIN	equ	14
IE_ANIMEDWIN2	equ	15
IE_CLRSCR	equ	16
IE_WAITKEY	equ	17
